/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.relics;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.Omamori;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rooms.TreasureRoomBoss;
import com.megacrit.cardcrawl.unlock.UnlockTracker;

public class CallingBell
extends AbstractRelic {
    public static final String ID = "Calling Bell";
    private boolean cardsReceived = true;

    public CallingBell() {
        super(ID, "bell.png", AbstractRelic.RelicTier.BOSS, AbstractRelic.LandingSound.SOLID);
    }

    @Override
    public String getUpdatedDescription() {
        return this.DESCRIPTIONS[0];
    }

    @Override
    public void onEquip() {
        this.cardsReceived = false;
        CardGroup group = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
        for (int i = 0; i < 3; ++i) {
            if (AbstractDungeon.player.hasRelic("Omamori") && AbstractDungeon.player.getRelic((String)"Omamori").counter != 0) {
                ((Omamori)AbstractDungeon.player.getRelic("Omamori")).use();
                continue;
            }
            AbstractCard bellCurse = AbstractDungeon.getCard(AbstractCard.CardRarity.CURSE);
            UnlockTracker.markCardAsSeen(bellCurse.cardID);
            group.addToBottom(bellCurse.makeCopy());
        }
        AbstractDungeon.gridSelectScreen.openConfirmationGrid(group, this.DESCRIPTIONS[1]);
        CardCrawlGame.sound.playA("BELL", MathUtils.random(-0.2f, -0.3f));
    }

    @Override
    public void update() {
        super.update();
        if (!this.cardsReceived && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.GRID) {
            AbstractDungeon.combatRewardScreen.open(this.DESCRIPTIONS[1]);
            AbstractDungeon.combatRewardScreen.rewards.clear();
            for (int i = 0; i < 3; ++i) {
                AbstractDungeon.combatRewardScreen.rewards.add(new RewardItem(AbstractDungeon.returnRandomScreenlessRelic(AbstractDungeon.returnRandomRelicTier())));
            }
            AbstractDungeon.combatRewardScreen.positionRewards();
            if (AbstractDungeon.getCurrRoom() instanceof TreasureRoomBoss) {
                AbstractDungeon.overlayMenu.proceedButton.setLabel(this.DESCRIPTIONS[2]);
            } else {
                AbstractDungeon.overlayMenu.proceedButton.hideInstantly();
                AbstractDungeon.overlayMenu.cancelButton.show(this.DESCRIPTIONS[3]);
            }
            this.cardsReceived = true;
            AbstractDungeon.getCurrRoom().rewardPopOutTimer = 0.25f;
        }
        if (this.hitbox.hovered && InputHelper.justClickedLeft) {
            CardCrawlGame.sound.playA("BELL", MathUtils.random(-0.2f, -0.3f));
            this.flash();
        }
    }

    @Override
    public AbstractRelic makeCopy() {
        return new CallingBell();
    }
}

